<?php
defined('PF_VERSION') OR exit('Access denied');
/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (vudoanthang83@gmail.com)
 * @copyright	PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
function is_ajax()
{
    return ((isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') || !empty($_GET['ajax'])) ? true : false;
}

/**
 * 
 * Execute widgets
 * @param unknown $widgets
 */
function load_widgets($widgets = array(), $setting_data, $active_widgets)
{
    global $theme;
    $active_widgets = (is_array($active_widgets)) ? $active_widgets : array();
    foreach ($widgets as $widget) {
        if (!empty($widget['id'])) {
            $widget_id = str_replace('widget_', '', strtolower($widget['id']));
            if (!in_array($widget_id, $active_widgets))
                continue;
            $widget_class = ucfirst($widget_id) . '_Widget';

            if (!class_exists($widget_class)) {
                if (is_file(ABSPATH . '/themes/' . $theme . '/widgets/' . $widget_id . '/' . $widget_id . '.php')) {
                    require ABSPATH . '/themes/' . $theme . '/widgets/' . $widget_id . '/' . $widget_id . '.php';
                } else {
                    // Error: Widget class is not found.
                }
            }

            if (class_exists($widget_class) && get_parent_class($widget_class) == 'Pf_Widget') {
                $widget_object = new $widget_class($widget, $setting_data);
                if (method_exists($widget_object, 'main')) {
                    $widget_object->main();
                } else {
                    // Error: Widget main method is not found.
                }
            } else {
                // Error: Widget class must extend Pf_Widget .
            }
        } else {
            // Error: Widget don't have the id.
        }
    }
}

function parse_atts($attributes, $default = array())
{
    if (is_array($attributes)) {
        foreach ($default as $key => $val) {
            if (isset($attributes [$key])) {
                $default [$key] = $attributes [$key];
                unset($attributes [$key]);
            }
        }

        if (count($attributes) > 0) {
            $default = array_merge($default, $attributes);
        }
    }

    $att = '';
    foreach ($default as $key => $val) {
        $val = form_prep($val);
        $att .= $key . '="' . $val . '" ';
    }

    return $att;
}

function has_active_widget($widgets = array(), $active_widgets)
{
    $flag = false;
    $active_widgets = (is_array($active_widgets)) ? $active_widgets : array();
    foreach ($widgets as $widget) {
        if (!empty($widget['id'])) {
            $widget_id = str_replace('widget_', '', strtolower($widget['id']));
            if (in_array($widget_id, $active_widgets)) {
                $flag = true;
                break;
            }
        }
    }

    return $flag;
}

function public_css($link, $external = false)
{
    global $_public_css;

    $_public_css [$link] = array($link, $external);
}

function public_js($js, $external = false)
{
    global $_public_js;

    $_public_js [$js] = array($js, $external);
}

function load_css_js($html, $theme)
{
    global $_public_css;
    global $_public_js;

    $str_css = '<!-- include css -->' . " \n\t";
    foreach ($_public_css as $css) {
        if ($css[1] == false) {
            $str_css .= '<link href="' . RELATIVE_PATH . '/themes/' . $theme . '/' . preg_replace('/\\\/', '/', $css[0]) . '" rel="stylesheet">' . " \n\t";
        } else {
            $str_css .= '<link href="' . preg_replace('/\\\/', '/', $css[0]) . '" rel="stylesheet">' . " \n\t";
        }
    }
    $html = str_replace('<!-- include css (do not remove this line) -->', $str_css, $html);

    $str_js = '<!-- include javascript -->' . " \n\t";
    foreach ($_public_js as $js) {
        if ($js[1] == false) {
            $str_js .= '<script src="' . RELATIVE_PATH . '/themes/' . $theme . '/' . preg_replace('/\\\/', '/', $js[0]) . '"></script>' . " \n\t";
        } else {
            $str_js .= '<script src="' . preg_replace('/\\\/', '/', $js[0]) . '"></script>' . " \n\t";
        }
    }
    $html = str_replace('<!-- include javascript (do not remove this line) -->', $str_js, $html);

    return $html;
}

//Head info
function set_head_info($info)
{
    global $head_info;
    $head_info = $info;
}

function get_head_info($key)
{
    global $head_info;
    return isset($head_info[$key]) ? $head_info[$key] : '';
}

//Get configuration
function get_configuration($key, $name = 'general')
{
    return Pf::setting()->get_element_value($name, $key);
}

//Redirect to install page
function redirect_to_install($abs_path)
{
    require $abs_path . '/includes/helper/url-helper.php';
    define('RELATIVE_PATH', (strpos($_SERVER["SCRIPT_NAME"], '/admin/') !== false) ? dirname(substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/'))) : substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/')));
    header('Location: ' . site_url() . RELATIVE_PATH . '/installs/index.php?step=1');
    exit();
}

/**
 * Function update key in widget category
 */
if (!function_exists('get_site_url')) {

    function get_site_url($url = '')
    {
        $relative = RELATIVE_PATH;
        if (empty($relative)) {
            return site_url() . '/' . $url;
        }
        return site_url() . "{$relative}/{$url}";
    }

}

if (!function_exists('get_key_widget_shortcode_post')) {

    function get_key_widget_shortcode_post()
    {
        $option = get_configuration('page_lists', 'pf_post');
        $keys = array();
        if (empty($option)) {
            return;
        }
        Pf::database()->query('SELECT page_content FROM pf_pages WHERE page_url="' . $option . '" LIMIT 1');
        $content = Pf::database()->fetch_assoc();
        if (empty($content)) {
            return;
        }
        $matches = array();
        preg_match("/category\=\[get:([a-zA-Z0-9_]*)\]/i", $content['page_content'], $matches);
        if (!empty($matches[1])) {
            $keys['category'] = $matches[1];
        }
        preg_match("/tag\=\[get:([a-zA-Z0-9_]*)\]/i", $content['page_content'], $matches);
        if (!empty($matches[1])) {
            $keys['tag'] = $matches[1];
        }
        return $keys;
    }

}
if (!function_exists('upate_widget_category')) {

    function upate_widget_category()
    {
        $footer = get_option('footer');
        $layouts = get_option('layouts');
        $keys = get_key_widget_shortcode_post();
        $category_key = isset($keys['category']) ? $keys['category'] : '';
        $tag_key = isset($keys['tag']) ? $keys['tag'] : '';

        if (!empty($footer['setting_data'])) {
            foreach ($footer['setting_data'] as $key => $setting) {
                if (isset($setting['widget-key-category'])) {
                    $footer['setting_data'][$key]['widget-key-category'] = $category_key;
                }
                if (isset($setting['widget-key-tag'])) {
                    $footer['setting_data'][$key]['widget-key-tag'] = $tag_key;
                }
            }
            update_option('footer', $footer);
        }
        if (!empty($layouts)) {
            foreach ($layouts as $key_layout => $layout) {
                if (empty($layout['setting_data'])) {
                    continue;
                }
                foreach ($layout['setting_data'] as $key_setting => $setting) {
                    if (isset($setting['widget-key-category'])) {
                        $layouts[$key_layout]['setting_data'][$key_setting]['widget-key-category'] = $category_key;
                    }
//                    if (isset($setting['widget-key-tag'])) {
//                        $layouts[$key_layout]['setting_data'][$key_setting]['widget-key-tag'] = $tag_key;
//                    }
                }
            }
            update_option('layouts', $layouts);
        }
    }

}
if (!function_exists('noreply_email')) {

    function noreply_email()
    {
        return 'noreply@' . $_SERVER['HTTP_HOST'];
    }

}

/**
 * Functions thumbnail
 */
if (!function_exists('image_check_memory_usage')) {

    function image_check_memory_usage($img, $max_breedte, $max_hoogte)
    {
        if (file_exists($img)) {
            $K64 = 65536;    // number of bytes in 64K
            $memory_usage = memory_get_usage();
            $memory_limit = abs(intval(str_replace('M', '', ini_get('memory_limit')) * 1024 * 1024));
            $image_properties = getimagesize($img);
            $image_width = $image_properties[0];
            $image_height = $image_properties[1];
            $image_bits = $image_properties['bits'];
            $image_memory_usage = $K64 + ($image_width * $image_height * ($image_bits ) * 2);
            $thumb_memory_usage = $K64 + ($max_breedte * $max_hoogte * ($image_bits ) * 2);
            $memory_needed = intval($memory_usage + $image_memory_usage + $thumb_memory_usage);

            if ($memory_needed > $memory_limit) {
                ini_set('memory_limit', (intval($memory_needed / 1024 / 1024) + 5) . 'M');
                if (ini_get('memory_limit') == (intval($memory_needed / 1024 / 1024) + 5) . 'M') {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

}

if (!function_exists('no_image')) {

    function no_image()
    {
        return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAL0AAACUCAIAAABJFr+ZAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAA3DSURBVHja7J1fS1RdFMbP+2pYYChYmDSQkJiQkKSUYNhFoZKQXU0Xgd3pN+hD9A3yLqELhYK8kAwMCoSMFAUFDYQJFBpQSDBKMHgfZr0tdvvMnD/jmfHMmee5iKOzz0y1f7P+7L3WPv/s7u46FBVS//K/gCI3FLmhyA1FbiiK3FDkhiI3FLmhyA1FkRuK3FDkhiI3FLmhKHJDkRuK3FDkhiI3FEVuKHJDmdrY2Pj48WNJP6KW/8tJ0vfv39+/f7+5uXn69OmOjo7GxkZyQ/kINubTp0+/fv3CNf78+vUruaG8BETevHmzv78vP164cOH27duXLl2in6J8HJP8CPd048aN3t7eUn8uuUmIY4KuXbsGMwN0yvDR5KYi9e3bt9evX5fTMZGbhEihuXnzJqAp86dz/aYiBQMDXOR6Y2Oj/H8BclOpAjcSysDwlHqVj9wkR4BG3ROiYyRWHuEzci7GN9WVZsMNyQre4OCg9SoSKHkVKRXIGBkZsQaY6zqtra0RBs7kJqbClMNO4E/9EbPe0dFhDYPJmZycxMXm5qaMkd+DpLm5OXNd5+fPnxH+9f7hOW0xzLFhPJQYVUNDw+PHj93LMxi8uLgoA8bHx52yrOuQm3gJU/7hwwczb2pvb4eLwUWhW8DHxMSEUAJEstksyNPbS7SuQ25iJHiW1dVVucZk9/b2Bpxy3IV7rai5pBsOjG9iBw2mfGBgwB3KeEgD5NI5JubhcRRmXaFJp9OhoNEAWa9xe6l3qcjNyQuhydu3b+Ua0HiEMh4yV5CRe5f670xuTl4rKysS1fb39xcHjSjUCvIxa0nJzclLY+Gurq4i7jJj4SAryPj91NTUzMwMEjfNvBgXV5gwi7Kei9QpYFCiq8B1dXVWJOS9goxfwraZeX4mkynOwpGbE5Z+44Ok3FZ1H65bW1st2gqtIIMnjNfqC/weI4t2i+Tm5O1NwJHWKrDEMbAf1iKNBMiyggyzND4+jo9Akq9ZurgzWKbj/LXJTWXYJKu6r729XdwN/nT3u4AbRD8gDLcglDG3LG7mdPwsnXFxBQjTLNDgAjnX6OiouZRsrRRbAbJCg/G4Mar1QHJzkq4HOnPmjFxks9lCY2BOgAs8y9jYmHolLasAGe6SPwxWsAAKBj98+PA4Sb6lmidPnnCmIxSikNnZWXgWRKy1tbVBbMnS0hIufvz4gckudEsqlWprazNfxY01NTViTvBxnZ2d1r3nzp2Dt4JXQlaF26P9Z5KbKIUoZHl5+ejoaG9vDzPa3NxcX1/vy83a2trh4SHugl0JZRJAg9wLISe34MBHd3d3W7RFJfqpiAMRM5idnp52r865pakNbJWZLgXR0NCQXCBAdvvH0u1SkZso1dDQIBdXrlxx/hTd+db2dnV16f4A8upQnwiT5l4KKoPITZRqaWmRCwQ3akUWFxcnJyc9DInUyqjZcFf6eXtGJbWIXXRyEy97g6/+YE7648TEhAcQyJI0sgEKQSwHQMRIeU/c665aJzcVIwS24nEk1IDJQfYrv8E0T01NeWxBDwwM6EgERt5WB69ijGw4SJ1XedrCmU+FE+by4OAgyNxkMpn9nPr6+oQkeJCdnR3cLvONCyQ+7hwH6Q/MlaCA3Gp9fR0j63Myh8EULSwszM/PyxvC0qTTaaTcZf4PYX2xv2RHEBfSLeAt7S4YHR1V1yO705pb4fewEHlTboAF72MGQ4BJtxF081wTsbIdQEF7E05IiBCryhpJTU2N7wIa7IHGHEoGrEtbW5su08FUwK4ACLedEPuEL7Pygc/d/yNcK0wPHjzo7u4uxdoMuYlAS0tLOoXZbBaT6v39/v37N1yMk1uuRVZlvpTKaWtr6ygnoIM/rTESr3R2doovw0djjPnS5cuX4QGHhoZKdwYb/VQEshqawI27ndbS06dPndw+IoLivJ4IAbL+iGF4Qw8W4bNk68p0WCcu5lNBE2zJsaUYKkg27h4GAkChCY0MQ4rukXgDqUs5xQcachMotXZyK7m6qubbLaATbNKA4Pr58+dqusBBf3+/8jQ5OVn+s0iOI9Zt+UjrHJqbm2FIJD7FHHu0QoIJMTZIfxAae5TbtbS0aPYEpPDOJ5UfMS6OWJhFyavBDUyOrK94B8iSLonhgcl59eqVeaaaWdVgre7gbQPuotNPVQA3mg+DGymGkvUYXz8F4EzHlLfcDoPT6bRuZoGzTCZDP5WQoBgGQ4KVwcFBhLGOq1vAlLWg51sHLvV4+BS84XF6DGhvSqiwBS5qP2TNTUo2fQNknXsp7gzSPICAKdpSTnIT5WIMrIW1kB+QG02Ourq6JNP2aKfVspjg3XSVpWrhBrP+7NkzRBsgBi7Gu6oh73qM2qog7bR6S6gadXITR5k7glLVEPaUTW058A2QtYArVBEWuYmdzGM+1BhIJZ5vkZRCYB6tqHVSeVeQ9SM8ulvITRwFB4E4xmwsMo/5QGwr14DGd622rq7O7XS8A2Qt4IJBSqSrSiY34AA0wBLAiWgIbMYlq6ur6XRas2jEPXBbhYLlQjmOd4CsoXE5y8XJTZGCy9D418nVh5uvahcjZjqTySDvVZsh+4vezzqw/JEJorsNRWmjvakAxwSzofEvmEAU4j7mw5zp3t5eLcwDajMzM3Nzc27DU+iQEQ2QHVeftng3vOqusEmAkrM/tbKysry8bJHU09NjDauvrz86OtrZ2cH17u5uZ2cnfiPtTvJLRLKwOqlUytwkWl9fN6uGTWGkNOri1aamJi3hq62tBY537tyJ/2ZTVXMjpXQXL14cHh6WUrpClZ2YTsQ3GKAzjTmGVdBiPNyIAea9BwcH4qTc3BTq0wYulbL4W9XcOLliPLEfmEsQ4BTYuMa86gBzppEEIQCCldrb25NoZnt7G+hgMC6EDPzorp8CeTBRoA2Rct5eBXITa+mE4YuOmZbiXJgKdyOjDrA68vEOGAzy4LPEIMFDgZvz589L1TAgc3ODuzCgu7vbfSgEuakwySkeuIDxKGQkZAAMydWrV02bBKq0qQD0wDKBBlnBg1/L29KA909kHFNd6zdOgHOgzQHuI6vAgZmlBzlWoqqU5H0G33OgdUDeI6ucXG2D2T7nJHe/idz8lel4b1ybA8yVZcssAR21TFTyuXGMBeJCG9fmCrLH2TPAC26roaEhwak1ubGnXC4KtT557BWYAl7j4+Plf1I386lAwszhe7+0tIRQdD0nJNJIZ4rOVswFYuTeQVaQiYWvYtTnW+i5kiL4CESpxZ3ybT5JECmSu/XJHHD//v1yHlxFe1O8MGELCwuzs7NmSZ6lw8PDra0tGIwiDsg0F4hDrSBT8eVGjpfSZ1Ug8Ozr67uTEy5SqVRTUxMmW45lAFgwSJj4sPNa9AoyFUduBBqpbMI3/t69e8AFU6j2oLGxEVMo7klCENliLAKdgCvISLkRA9HexJqbly9fCg2yTFIoy5X9agSw4kqAjniTYwbIoPbz589qWkp6UDS5iUz4ckvlCmLeR48e+fYZgSqtWIBDCXL6lfsdpIICzggJwbt37wCiVTRDJuK+fqNr/0NDQwGb05AKSY2Vk1sCDtt8aS4QI6KS27l1UEncbGxsSPYEGxDw6eoiLf2Up/6FDafMXhZpzC7zyb/k5ljSldn29vaibQZMTqh7EYPrARGIfwN2blMx4ka9g3a1BRcmWxpQYD9CVTgIo9E+wYvcRJ9jl+7sMfPAmOB3ITyK/Ale1alSpQ/m02M9jjQrWkjLxeOEPWWIjinW9kZOaw6S9RTXlqYGw2Nrgqo8bnwLXzSHKroNNlQWRlVMfGM2Y7vXSDQc1p0pitz870q0vNJtcvQgqrA5kZWRMSdKYB6uhd9wRu7cSh/yVsRzJdW70VslkBtrjc6C4zjPlVQTlciu/WRyE8o2eATIRT9XEsZGuME76HYVFWtu5EjOqamp4NPsESAX8VxJ5O3T09Pq6RjfnIhC1FFgUl+8ePHlyxdtnN7e3j579qzvc0rMwpe9vT1r5a25uVmOj5BHMuV9mpcZCwMaMXiwNHfv3uUUxp2bg4MDax8xOD1a+II3sepmrOdK4mJ3d9fdbg0zAzc3Pz8vBaN4w5GREZbLnJTC9TPowyPhHeShFWZeDafjkd2AG2nDxr1jY2OWf8n7XEnAAWsEOrPZrPlZSNPYx1Qx9sY0G9D169c7OjqAnRxA72t7zMpw8NHW1ma+mve5knBq4AnQyONSnD/PleQeU4VxYzWU4Et/69YtOJSA9GhlOO51V4Z7PFdSopmenp7h4eFYPfaNfiqENJkyHzYJIJBqmbuMeT2XejopRPcOw/XxtVzcq2x7Y5kNs6EEHMAe+NoejwDZnYU1/hHnKQnceHRcCz2gAViI7RF6xLXhVcvTIVJhTlQt3Dh/N5S4zQYshEQqSg8uwMra2tqpU6fAigbIyK7ZjF1F3Ph2XOelR3q8QQ/GS+tuodZJKpncOAE6rj3oQVit6VLes0WoxHLjBOi49qBHVeh0aiqx3PgeSRSEHvbxV8v6jSnfI4kKSY7wRIzMlpRq5Mb5e+NpdHSUQW41KIJ6P9/WBYrc5JfvmZ0Uucmfk3sfak+Rm/zyPdSeIjd5FORp7BS58QmQpViCIjchAmTWcSZe0Z+XDmPD3hTam2ICHf63khuKIjcUuaHIDUVuKHJDUeSGIjcUuaHIDUVuKIrcUOSGIjcUuaHIDUWRGypS/SfAALyGnk5eYdhMAAAAAElFTkSuQmCC";
    }

}

if (!function_exists('check_type_image')) {

    function check_type_image($path)
    {
        $a = getimagesize($path);
        $image_type = $a[2];
        if (in_array($image_type, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_BMP))) {
            return true;
        }
        return false;
    }

}

if (!function_exists('get_thumbnails')) {

    function get_thumbnails($file, $width = 160, $full_url = true)
    {
        $absolute_path_file = ABSPATH . '/' . $file;
        // If the original file and need to resize the width is greater than 0, then further processed
        if (file_exists($absolute_path_file) && is_file($absolute_path_file) && check_type_image($absolute_path_file) && $width > 0) {
            $thumnail_relative_path = dirname($file) . "/thumbs/{$width}/";
            $thumnail_file_name = $thumnail_relative_path . basename($file);
            $thumbnail_url = ($full_url ? site_url() . RELATIVE_PATH . '/' : '') . $thumnail_file_name;

            // Style file thumbnails investigation already exists. If exists returns thumbnails
            if (file_exists($thumbnail_absolute_file = ABSPATH . '/' . $thumnail_file_name)) {
                return $thumbnail_url;
            }

            // If the folder does not exist, then create thumbnails folder
            if(!file_exists(ABSPATH . '/' . $thumnail_relative_path)){
                if(!mkdir(ABSPATH . '/' . $thumnail_relative_path, 0777, true)){
                    return no_image();
                }
            }            

            // Get the width and height to calculate the height of the file changes
            list($width_old, $height_old) = getimagesize($absolute_path_file);
            $height = $height_old * ($width / $width_old);

            // Check there is enough RAM to handle and not proceed to create thumbnail image
            if (image_check_memory_usage($absolute_path_file, $width, $height)) {
                $img = new SimpleImage(ABSPATH . '/' . $file);
                $img->resize($width, $height)->save($thumbnail_absolute_file, 90);
                return $thumbnail_url;
            }
        }
        return no_image();
    }

}

if (!function_exists('show_widget_tags')) {

    function show_widget_tags($limit = 10)
    {
        Pf::database()->query("SELECT t.id,tag_name FROM pf_post_tags pt LEFT JOIN pf_tags t ON pt.post_tag_tag_id = t.id GROUP BY post_tag_tag_id LIMIT {$limit}");
        return Pf::database()->fetch_assoc_all();
    }

}

// Function string URL
if (!function_exists('removesign')) {

    function removesign($str)
    {
        $coDau = array("à", "á", "ạ", "ả", "ã", "â", "ầ", "ấ", "ậ", "ẩ", "ẫ", "ă", "ằ", "ắ"
            , "ặ", "ẳ", "ẵ", "è", "é", "ẹ", "ẻ", "ẽ", "ê", "ề", "ế", "ệ", "ể", "ễ", "ì", "í", "ị", "ỉ", "ĩ",
            "ò", "ó", "ọ", "ỏ", "õ", "ô", "ồ", "ố", "ộ", "ổ", "ỗ", "ơ"
            , "ờ", "ớ", "ợ", "ở", "ỡ",
            "ù", "ú", "ụ", "ủ", "ũ", "ư", "ừ", "ứ", "ự", "ử", "ữ",
            "ỳ", "ý", "ỵ", "ỷ", "ỹ",
            "đ",
            "À", "Á", "Ạ", "Ả", "Ã", "Â", "Ầ", "Ấ", "Ậ", "Ẩ", "Ẫ", "Ă"
            , "Ằ", "Ắ", "Ặ", "Ẳ", "Ẵ",
            "È", "É", "Ẹ", "Ẻ", "Ẽ", "Ê", "Ề", "Ế", "Ệ", "Ể", "Ễ",
            "Ì", "Í", "Ị", "Ỉ", "Ĩ",
            "Ò", "Ó", "Ọ", "Ỏ", "Õ", "Ô", "Ồ", "Ố", "Ộ", "Ổ", "Ỗ", "Ơ"
            , "Ờ", "Ớ", "Ợ", "Ở", "Ỡ",
            "Ù", "Ú", "Ụ", "Ủ", "Ũ", "Ư", "Ừ", "Ứ", "Ự", "Ử", "Ữ",
            "Ỳ", "Ý", "Ỵ", "Ỷ", "Ỹ",
            "Đ", "ê", "ù", "à");
        $khongDau = array("a", "a", "a", "a", "a", "a", "a", "a", "a", "a", "a"
            , "a", "a", "a", "a", "a", "a",
            "e", "e", "e", "e", "e", "e", "e", "e", "e", "e", "e",
            "i", "i", "i", "i", "i",
            "o", "o", "o", "o", "o", "o", "o", "o", "o", "o", "o", "o"
            , "o", "o", "o", "o", "o",
            "u", "u", "u", "u", "u", "u", "u", "u", "u", "u", "u",
            "y", "y", "y", "y", "y",
            "d",
            "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A"
            , "A", "A", "A", "A", "A",
            "E", "E", "E", "E", "E", "E", "E", "E", "E", "E", "E",
            "I", "I", "I", "I", "I",
            "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"
            , "O", "O", "O", "O", "O",
            "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U",
            "Y", "Y", "Y", "Y", "Y",
            "D", "e", "u", "a");
        return str_replace($coDau, $khongDau, $str);
    }

}
if (!function_exists('url_title')) {

    function url_title($str, $separator = '-', $lowercase = true)
    {
        if ($separator === 'dash') {
            $separator = '-';
        } elseif ($separator === 'underscore') {
            $separator = '_';
        }

        $q_separator = preg_quote($separator, '#');

        $trans = array(
            '&.+?;' => '',
            '[^a-z0-9 _-]' => '',
            '\s+' => $separator,
            '(' . $q_separator . ')+' => $separator
        );

        $str = strip_tags($str);
        foreach ($trans as $key => $val) {
            $str = preg_replace('#' . $key . '#i', $val, $str);
        }

        if ($lowercase === TRUE) {
            $str = strtolower($str);
        }

        return trim(trim($str, $separator));
    }

}

if (!function_exists('public_base_url')) {
    /**
     * Get base url site
     * @return string
     */
    function public_base_url() {
        return RELATIVE_PATH == '' ? site_url() . '/' : site_url() . RELATIVE_PATH . '/';
    }
}

if (!function_exists('public_url')) {
    /**
     * Create a page of links attached to the base url
     * @param string $url URL you want to pair with base url
     * @param boolean $page_default There are not using the default page?
     * @return string 
     */
    function public_url($url = '', $page_default = false) {
        $page = $page_default === true && !empty($_GET['pf_page_url']) ?  $_GET['pf_page_url'] . '/' : '';
        return public_base_url() . (MOD_REWRITE == FALSE ? 'index.php/' : '') . $page . $url;
    }
}

